# Introduction -------

#This is the code for the first figure in our eLife Manuscript

#The figure will include:

# - The drawing of the behavioural task
# - Hypnography summary data


# Load packages and prepare defaults ----

pacman::p_load(tidyverse,ggpmisc,cowplot,ggcorrplot,GGally,
               broom,ghibli,patchwork,survival)

#Get our default settings
source("./eLife Submission Scripts/Analysis-Common-Utilities.R")


# Figure 1 =====

## Fig 1A: Diagram ------

#this was drawn directly in Inkscape so not in R


## Fig 1B: Reaching criteria plot -----

d_surv = 
  meta %>%
  drop_na(age_eeg) %>%
  mutate(reachCrit = ifelse(!is.na(rep2Crit_evening),1,0))

surv_fit = 
  survfit(Surv(maxCyc_evening,reachCrit) ~ group, data = d_surv) 

surv_d = 
  surv_fit %>% 
  tidy() %>%
  mutate(strata = ifelse(strata == "group=Sib","Sib","22q"))

p_b1 = 
  surv_d %>%
  ggplot(aes(x = time, y = 1-estimate, ymin = 1-conf.high,ymax = 1-conf.low, 
             colour = strata, fill = strata)) +
  geom_step(size = 1)+
  pammtools::geom_stepribbon(alpha = 0.4) +
  geom_point(data = surv_d |> filter(n.censor > 0), 
             aes(x = time, y = 1-estimate), color = "black") +
  theme_bw()  +
  labs(x = "Learning Cycles (n)", y = "Proportion reached Criteron") +
  theme(panel.grid = element_blank(),
        axis.text  = element_text(colour  = "grey20", size = 8),
        axis.title = element_text(colour  = "black" , size = 8),
        axis.text.y = element_text(colour = "grey20", size = 8),
        axis.text.x = element_text(colour = "grey20", size = 8),
        legend.position = "none") +
  scale_colour_manual(values = cols) +
  scale_fill_manual(values = cols)



## Fig 1C: Morning Accuracy Plot ---- 

p_b2 <- 
  meta %>%
  drop_na(age_eeg,hits_morning) %>%
  ggplot(aes(x = group, fill = group, y = hits_morning)) +
  geom_boxplot(alpha = 0.9,
               outlier.color = NA,
               outlier.fill = NA,
               colour = "black") +
  geom_point(position = ggforce::position_jitternormal(sd_x = 0.05, sd_y = 0),
             shape = 21, colour = "black",
             size = 2,
             alpha = 0.6) +  
  labs(y = "Morning Hits (n)", x = NULL) +
  theme_bw() +
  theme(panel.grid = element_blank(),
        axis.text  = element_text(colour  = "grey20", size = 8),
        axis.title = element_text(colour  = "black" , size = 8),
        axis.text.y = element_text(colour = "grey20", size = 8),
        axis.text.x = element_text(colour = "grey20", size = 8),
        legend.position = "none") +
  scale_fill_manual(values = cols) +
  scale_y_continuous(breaks = c(0,2,4,6,8,10,12)) +
  coord_cartesian(ylim = c(0,12))


# The asterix is added in Inkscape. Alternatively we could add as a 
#geom_text

## Fig 1D: Evening-Morning Difference Plot ===-----


p_b3 =
  meta %>%
  select(subject,group,accC_evening,accC_morning) %>%
  drop_na() %>%
  mutate(evening = round(((accC_evening)*15)/100,digits = 0),
         morning = round(((accC_morning)*15)/100,digits = 0)) %>%
  select(subject,group,evening,morning) %>%
  pivot_longer(-c(subject, group),names_to = "session",values_to = "hits") %>%
  mutate(session = factor(session,levels = c("evening","morning"))) %>%
  ggplot(aes(x = session, fill = group, y = hits, group = subject,colour = group)) +
  geom_line(size = 0.75, lty = 1, alpha = 0.6)+
  geom_point(position = ggforce::position_jitternormal(sd_x = 0.02, sd_y = 0.1),
             shape = 21, colour = "black",
             size = 2,
             alpha = 0.6) +
  
  labs(y = "Hits Difference", x = NULL) +
  theme_bw() +
  theme(panel.grid = element_blank(),
        axis.text  = element_text(colour  = "grey20", size = 8),
        axis.title = element_text(colour  = "black" , size = 8),
        axis.text.y = element_text(colour = "grey20", size = 8),
        axis.text.x = element_text(colour = "grey20", size = 8),
        legend.position = "none") +
  scale_fill_manual(values = cols) +
  scale_colour_manual(values = cols) +
  scale_y_continuous(breaks = c(0,2,4,6,8,10,12)) +
  coord_cartesian(ylim = c(0,12))


## Fig 1E: Sleep Properties ----


# Sleep characteristics from the hypnography

#Make plots for the variables we want

measure_details <- c(
  tst_eeg          = "TST (Min)",
  se_eeg           = "SE (%)",
  latencyn1_eeg    = "N1 Lat (Min)",
  latencyrem_eeg   = "REM Lat (Min)",
  waso_eeg         = "Awakenings (n)",
  percnightn1_eeg  = "N1 (%)",
  percnightn2_eeg  = "N2 (%)",
  percnightn3_eeg  = "N3 (%)",
  percnightrem_eeg = "REM (%)")


p_h1 = 
  meta |>
  drop_na(age_eeg) |>
  select(group,
         tst_eeg,se_eeg,latencyn1_eeg,latencyrem_eeg,
         percnightn1_eeg,percnightn2_eeg,percnightn3_eeg,percnightrem_eeg,waso_eeg) %>%
  pivot_longer(-group) |>
  mutate(name = factor(name, levels = c("tst_eeg","se_eeg","latencyn1_eeg","latencyrem_eeg","waso_eeg",
                                        "percnightn1_eeg","percnightn2_eeg","percnightn3_eeg","percnightrem_eeg"))) %>%
  ggplot(aes(x = group, y = value,fill = group,colour = group)) +
  # geom_boxplot(position = position_dodge(width = 1),lwd = 0.5,alpha = 1) +
  geom_boxplot(alpha = 0.9,
               outlier.color = NA,
               outlier.fill = NA,
               colour = "black") +
  geom_point(position = ggforce::position_jitternormal(sd_x = 0.05, sd_y = 0),
             shape = 21, colour = "black",
             size = 2,
             alpha = 0.6) +  
  facet_wrap(~name,ncol = 5,
             scales = "free_y",
             labeller = labeller(name = measure_details))+
  labs(y = NULL, x = "Group") +
  theme_bw() +
  theme(panel.grid = element_blank(),
        #panel.border = element_blank(),
        strip.background = element_blank(),
        axis.text  = element_text(colour = "grey20",size = 8),
        axis.title = element_text(colour = "black",size = 8),
        axis.text.y = element_text(colour = "grey20",size = 8),
        axis.text.x = element_text(colour = "grey20",size = 8),
        legend.position = "none",
        title = element_text(colour = "black",size = 8)) +
  scale_fill_manual(values = cols)  +
  scale_colour_manual(values = cols) 







## Assemble =====

p1 = 
  (p_h1 / (p_b1 + p_b2 + p_b3 + plot_spacer() + plot_layout(widths = c(2,1.5,1.5,2)))) + plot_layout(heights = c(2,1)) +
  plot_annotation(tag_levels = "A")


  
##Save the plot -----

#You can save the plot like this:
 ggsave("./Figures/figure_1.pdf",plot = p1, width = 16, height = 12, units = "cm")


# Figure Supplement 1: Individual Psych Data ======

## Fig  1 - S1A ====

#A reviewer asked for more individual data: here we plot all of the covariates in table 1

measure_details <- c(
  age_eeg          = "Age (Years)",
  fsiqall          = "FSIQ",
  sleepprobsall    = "Sleep Problems",
  anyanxsymsall    = "Anxiety Symptoms",
  adhdsymsall      = "ADHD Symptoms",
  asqtotalsymsall  = "ASD Symptoms")

p_s1 = 
  meta |>
  drop_na(age_eeg) |>
  select(group,
         age_eeg,fsiqall,sleepprobsall,anyanxsymsall,adhdsymsall,asqtotalsymsall) %>%
  mutate(fsiqall = map_dbl(fsiqall,~ifelse(.x < 50,NA,.x))) |> 
  pivot_longer(-c(group)) |>
  mutate(name = factor(name, levels = c("age_eeg","fsiqall","sleepprobsall","anyanxsymsall",
                                        "adhdsymsall","asqtotalsymsall"))) %>%
  ggplot(aes(x = group, y = value,fill = group,colour = group)) +
  geom_boxplot(alpha = 0.9,
               outlier.color = NA,
               outlier.fill = NA,
               colour = "black") +
  geom_point(position = ggforce::position_jitternormal(sd_x = 0.05, sd_y = 0),
             shape = 21, colour = "black",
             size = 2,
             alpha = 0.6) +  
  facet_wrap(~name,ncol = 6,
             scales = "free_y",
             labeller = labeller(name = measure_details))+
  labs(y = NULL, x = "Group") +
  theme_bw() +
  theme(panel.grid = element_blank(),
        strip.background = element_blank(),
        axis.text  = element_text(colour = "grey20",size = 8),
        axis.title = element_text(colour = "black",size = 8),
        axis.text.y = element_text(colour = "grey20",size = 8),
        axis.text.x = element_text(colour = "grey20",size = 8),
        legend.position = "none",
        title = element_text(colour = "black",size = 8)) +
  scale_fill_manual(values = cols)  +
  scale_colour_manual(values = cols) 


## Fig 1 - S1B =====

#Do as a scatter with age, including the hypnographic measures too

measure_details <- c(
  fsiqall          = "FSIQ",
  sleepprobsall    = "Sleep Problems",
  anyanxsymsall    = "Anxiety Symptoms",
  adhdsymsall      = "ADHD Symptoms",
  asqtotalsymsall  = "ASD Symptoms",
  tst_eeg          = "TST (Min)",
  se_eeg           = "SE (%)",
  latencyn1_eeg    = "N1 Lat (Min)",
  latencyrem_eeg   = "REM Lat (Min)",
  waso_eeg         = "Awakenings (n)",
  percnightn1_eeg  = "N1 (%)",
  percnightn2_eeg  = "N2 (%)",
  percnightn3_eeg  = "N3 (%)",
  percnightrem_eeg = "REM (%)")


p_s2 = 
  meta |>
  drop_na(age_eeg) |>
  select(group,
         age_eeg,fsiqall,sleepprobsall,anyanxsymsall,adhdsymsall,asqtotalsymsall,
         tst_eeg,se_eeg,latencyn1_eeg,latencyrem_eeg,waso_eeg,
         percnightn1_eeg,percnightn2_eeg,percnightn3_eeg,percnightrem_eeg) %>%
  mutate(fsiqall = map_dbl(fsiqall,~ifelse(.x < 50,NA,.x))) |> #Remove outliers
  pivot_longer(-c(group,age_eeg)) |>
  mutate(name = factor(name, levels = c("fsiqall","sleepprobsall","anyanxsymsall",
                                        "adhdsymsall","asqtotalsymsall",
                                        "tst_eeg","se_eeg","latencyn1_eeg","latencyrem_eeg","waso_eeg",
                                        "percnightn1_eeg","percnightn2_eeg","percnightn3_eeg","percnightrem_eeg"))) %>%
  ggplot(aes(x = age_eeg,y = value, fill = group,colour = group)) +
  geom_point(size = 0.5,alpha = 0.6) +
  geom_smooth(size = 0.5,
              formula = y ~ x,method = "lm") +
  theme_bw() +
  theme(panel.grid = element_blank(),
        strip.background = element_blank(),
        axis.text  = element_text(colour = "grey20",size = 8),
        axis.title = element_text(colour = "black",size = 8),
        axis.text.y = element_text(colour = "grey20",size = 8),
        axis.text.x = element_text(colour = "grey20",size = 8),
        legend.position = "none",
        title = element_text(colour = "black",size = 8)) +
  scale_fill_manual(values = cols)  +
  scale_colour_manual(values = cols) +
  labs(x = "Age (Years)") +
  facet_wrap(~name,ncol = 5,
             scales = "free_y",
             labeller = labeller(name = measure_details))

## Assemble =====

p_individual = p_s1 / p_s2 + plot_annotation(tag_levels = "A") + plot_layout(heights = c(1,3))

## Save supplementary figure =====

ggsave("./Figures/figure_1_supplement_1.pdf",plot = p_individual, width = 19, height = 16, units = "cm")

